#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

#endregion

namespace gov.va.med.vbecs.GUI
{
	#region Header

	//<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	//<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	//<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	//<Developers>
	//	<Developer>Margaret Jablonski</Developer>
	//</Developers>
	//<SiteName>Hines OIFO</SiteName>
	//<CreationDate>6/7/2004</CreationDate>
	//<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	//<summary></summary>

	#endregion

	/// <summary>
	/// Class DlgReturnUnitsInfo
	/// </summary>
	public class DlgReturnUnitsInfo : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		/// <summary>
		/// Is form loading
		/// </summary>
		private bool _isLoading = false;

		/// <summary>
		/// Name of the person that returned the unit
		/// </summary>
		private string _returnTechId;

		/// <summary>
		/// Date and time that the unit was returned
		/// </summary>
		private DateTime _returnDateTime;
		
		/// <summary>
		/// Division specific current date and time    
		/// </summary>
		private DateTime _currentDateTime;

		/// <summary>
		/// Array list of Vbecs Users
		/// </summary>
		private System.Collections.ArrayList _alVbecsUsers;

		private BOL.VbecsUser [] _userArray;

		#endregion

		#region Form Controls
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.GroupBox grpReturnInfo;
		private System.Windows.Forms.DateTimePicker dtpReturnDate;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbReturnBy;
		private System.Windows.Forms.Label lblReturnDate;
		private System.Windows.Forms.Label lblReturnBy;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructos/Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgReturnUnitsInfo()
		{
			this._isLoading = true;
			
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			SetComponentProperties();
			LoadVbecsUsers();

			this._isLoading = false;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgReturnUnitsInfo));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.grpReturnInfo = new System.Windows.Forms.GroupBox();
			this.dtpReturnDate = new System.Windows.Forms.DateTimePicker();
			this.cmbReturnBy = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblReturnDate = new System.Windows.Forms.Label();
			this.lblReturnBy = new System.Windows.Forms.Label();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpImage.SuspendLayout();
			this.grpReturnInfo.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(320, 30);
			this.vbecsLogo1.TabIndex = 3;
			this.vbecsLogo1.Title = "Return Issued Units";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 141);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 96);
			this.grpImage.TabIndex = 4;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 12);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(45, 45);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picImage.TabIndex = 0;
			this.picImage.TabStop = false;
			// 
			// grpReturnInfo
			// 
			this.grpReturnInfo.AccessibleDescription = "Return Information";
			this.grpReturnInfo.AccessibleName = "Return Information";
			this.grpReturnInfo.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReturnInfo.Controls.Add(this.dtpReturnDate);
			this.grpReturnInfo.Controls.Add(this.cmbReturnBy);
			this.grpReturnInfo.Controls.Add(this.lblReturnDate);
			this.grpReturnInfo.Controls.Add(this.lblReturnBy);
			this.grpReturnInfo.Location = new System.Drawing.Point(60, 32);
			this.grpReturnInfo.Name = "grpReturnInfo";
			this.grpReturnInfo.Size = new System.Drawing.Size(260, 96);
			this.grpReturnInfo.TabIndex = 0;
			this.grpReturnInfo.TabStop = false;
			this.grpReturnInfo.Text = "Return Information";
			// 
			// dtpReturnDate
			// 
			this.dtpReturnDate.AccessibleDescription = "Return Date";
			this.dtpReturnDate.AccessibleName = "Return Date";
			this.dtpReturnDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpReturnDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpReturnDate.Location = new System.Drawing.Point(80, 16);
			this.dtpReturnDate.Name = "dtpReturnDate";
			this.dtpReturnDate.Size = new System.Drawing.Size(156, 20);
			this.dtpReturnDate.TabIndex = 1;
			this.dtpReturnDate.ValueChanged += new System.EventHandler(this.dtpReturnDate_ValueChanged);
			// 
			// cmbReturnBy
			// 
			this.cmbReturnBy.AccessibleDescription = "Return By";
			this.cmbReturnBy.AccessibleName = "Return By";
			this.cmbReturnBy.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbReturnBy.Interval = 1;
			this.cmbReturnBy.Location = new System.Drawing.Point(80, 44);
			this.cmbReturnBy.Name = "cmbReturnBy";
			this.cmbReturnBy.Size = new System.Drawing.Size(156, 22);
			this.cmbReturnBy.TabIndex = 3;
			this.cmbReturnBy.SelectedIndexChanged += new System.EventHandler(this.cmbReturnBy_SelectedIndexChanged);
			// 
			// lblReturnDate
			// 
			this.lblReturnDate.Location = new System.Drawing.Point(8, 16);
			this.lblReturnDate.Name = "lblReturnDate";
			this.lblReturnDate.Size = new System.Drawing.Size(72, 20);
			this.lblReturnDate.TabIndex = 0;
			this.lblReturnDate.Text = "Return Date*";
			this.lblReturnDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblReturnBy
			// 
			this.lblReturnBy.Location = new System.Drawing.Point(8, 44);
			this.lblReturnBy.Name = "lblReturnBy";
			this.lblReturnBy.Size = new System.Drawing.Size(72, 20);
			this.lblReturnBy.TabIndex = 2;
			this.lblReturnBy.Text = "Returned By*";
			this.lblReturnBy.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(154, 132);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 1;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnCancel.Location = new System.Drawing.Point(234, 132);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// DlgReturnUnitsInfo
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(320, 157);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpReturnInfo);
			this.hlphelpChm.SetHelpKeyword(this, "Return_Issued_Units_To_Blood_Bank.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.Name = "DlgReturnUnitsInfo";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Return Issued Units";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgReturnUnitsInfo_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpReturnInfo, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.grpImage.ResumeLayout(false);
			this.grpReturnInfo.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion
	
		#region Methods

		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC059.DlgReturnUnitsInfo());
			//
			//set custom date and time format
			this.dtpReturnDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			//set current date value based on the division time zone
			this._currentDateTime = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpReturnDate.Value = this._currentDateTime;
			this.ReturnedDateTime = this._currentDateTime;

			//Set the tooltips of the controls
			this.ttToolTip.SetToolTip(this.btnCancel, Common.StrRes.Tooltips.Common.Cancel().ResString);
			this.ttToolTip.SetToolTip(this.btnOK , Common.StrRes.Tooltips.Common.EnterRequiredData().ResString);
		}

		private void LoadVbecsUsers()
		{
			this.cmbReturnBy.Items.Clear();

			this._alVbecsUsers = BOL.VbecsUser.GetActiveDivisionUsers( Common.LogonUser.LogonUserDivisionCode );
			this._userArray = new BOL.VbecsUser[_alVbecsUsers.Count];

			int index = 0;

			//they cannot de-select this so no blank row needed
			foreach(Object obj in this._alVbecsUsers)
			{
				BOL.VbecsUser vbecsUser = (BOL.VbecsUser) obj;
				cmbReturnBy.Items.Add(vbecsUser.UserName);
				this._userArray[index++] = vbecsUser;
				
			}
			cmbReturnBy.Text = ThisUser.UserName;
			this.ReturnedTechId = ThisUser.UserNTLoginID;
		}

		#endregion

		#region Events / Event Handlers

		/// <summary>
		/// Sets that date and time the unit was returned
		/// Displaying BR_59.01 
		/// </summary>
		private void dtpReturnDate_ValueChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				if(this.dtpReturnDate.Value > this._currentDateTime)
				{
					this.errError.SetVbecsError(this.dtpReturnDate, Common.StrRes.SysErrMsg.Common.DateSetToFuture("Return Date").ResString); // **** 508 Compliance ***
				}
				else
				{
					this.errError.SetVbecsError(this.dtpReturnDate, string.Empty); // **** 508 Compliance ***
				}
				//
				this._returnDateTime = this.dtpReturnDate.Value;
				//
				// enable button if there is no error message
				this.btnOK.Enabled = this.errError.GetError(this.dtpReturnDate).Equals(string.Empty);
			}
		}

		/// <summary>
		/// Sets the return tech id
		/// </summary>
		private void cmbReturnBy_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				if (this.cmbReturnBy.SelectedIndex>-1)
				{
					this._returnTechId = this._userArray[cmbReturnBy.SelectedIndex].UserNTLoginID;
					this.btnOK.EnabledButton = true;
				}
				else
				{
					this._returnTechId = "";
					this.btnOK.EnabledButton = false;
				}
			}
		}

		/// <summary>
		/// Sets the dialog box return value to OK
		/// </summary>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.OK;
		}

		/// <summary>
		/// Sets the dialog box return value to Cancel
		/// </summary>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgReturnUnitsInfo_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnOK.EnabledButton == false)
			{
				textToSpeak = this.ttToolTip.GetToolTip(this.btnOK);
			}

			this.SpeakMessage( textToSpeak );		
		}

		#endregion
	
		#region Properties

		/// <summary>
		/// Name of the person that returned the unit property
		/// </summary>
		public String ReturnedTechId 
		{
			get
			{
				return this._returnTechId.ToUpper();
			}

			set
			{
				this._returnTechId = value.ToUpper();
			}
		}

		/// <summary>
		/// Date and time that the unit was returned property
		/// </summary>
		public DateTime ReturnedDateTime
		{
			get
			{
				return this._returnDateTime;
			}

			set
			{
				this._returnDateTime = value;
			}
		}

		#endregion
	}
}

